// napple1 ncurses Apple 1 emulator
// Copyright (C) 2008 Nobu Hatano
//
// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "configuration.h"
#include "screen.h"
#include "msgbuf.h"

static short replica1 = 0;

short getReplica1(void)
{
	return replica1;
}

void loadConfiguration(void)
{
	FILE *fd = fopen("napple1.cfg", "r");
	char buffer[256], *value;

	if (!fd) {
		print_msgbuf("Starting without napple1.cfg");
		return;
	}

	print_msgbuf("Reading napple.cfg");
	while (!feof(fd))
	{
		if (!fgets(buffer, 256, fd))
			continue;

		if (buffer[0] == '/' || buffer[0] == '\n')
			continue;

		*(strrchr(buffer, '\n')) = '\0';
		value = strrchr(buffer, '=') + 1;
		*(strrchr(buffer, '=')) = '\0';

		if (!strcmp(buffer, "terminalSpeed"))
			setTerminalSpeed(atoi(value));
		else if (!strcmp(buffer, "replica1"))
			replica1 = (short)(value[0] & 0x01);
		else
			;
	}

	fclose(fd);
}

void saveConfiguration(void)
{
	FILE *fd = fopen("napple1.cfg", "w");
	char buffer[256], terminalSpeed[11];

	strcpy(buffer, "// napple1 configuration file\n");
	fputs(buffer, fd);

	strcpy(buffer, "terminalSpeed=");
	sprintf(terminalSpeed, "%d", getTerminalSpeed());
	strcat(buffer, terminalSpeed);
	strcat(buffer, "\n");
	fputs(buffer, fd);

	strcpy(buffer, "replica1=");
	buffer[9] = (char)getReplica1() | 0x30;
	buffer[10] = '\n';
	buffer[11] = '\0';
	fputs(buffer, fd);

	fclose(fd);
}
